package cn.dolphin.core.sec;

import javax.crypto.*;
import javax.crypto.spec.DESedeKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;

/**
 * DESede 对称加密(单密钥算法，密钥可用于加密解密)
 * DES的改良版，安全强度高，处理速度较慢
 *
 */
@SuppressWarnings("all")
public class DESedeUtil {

    /**
     * 加密算法
     */
    public static String ALGORITHM = "DESede";
    /**
     * 密钥的长度：DESede支持112 、168位
     */
    public static int KEY_SIZE = 168;


    /**
     * 生成密钥
     * @param keyCode
     * @return 密钥
     */
    public static byte[] getKey(String keyCode) {
        try {
            // 实例化密钥生成器
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
            // SHA1密码随机数供应者
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(keyCode.getBytes("utf-8"));
            // 初始化
            kg.init(KEY_SIZE, secureRandom);
            // 生成秘密密钥
            SecretKey secretKey = kg.generateKey();
            // 获得密钥的二进制编码形式
            return secretKey.getEncoded();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }


    /**
     * 获取密钥Key
     * @param key 密钥
     * @return KEY_CODE
     */
    private static Key toKey(byte[] key) {
        try {
            // 实例化密钥材料
            DESedeKeySpec dks = new DESedeKeySpec(key);
            // 实例化秘密密钥工厂，返回秘密密钥
            SecretKeyFactory kf = SecretKeyFactory.getInstance(ALGORITHM);
            return kf.generateSecret(dks);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }

    /**
     * DESede加密
     * @param data 源数据
     * @param keyCode
     * @return 加密数据
     */
    public static byte[] encode(byte[] data, String keyCode) {
        try {
            // 获取密钥Key
            Key k = toKey(getKey(keyCode));
            // 创建密码器(算法，工作模式，填充方式)
            Cipher cipher = Cipher.getInstance(ALGORITHM+"/ECB/PKCS5Padding");
            // 初始化密码器，设置为加密模式
            cipher.init(Cipher.ENCRYPT_MODE, k);
            // 加密原数据
            return cipher.doFinal(data);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }

    /**
     * DESede解密
     * @param data 加密数据
     * @param keyCode
     * @return 源数据
     *
     */
    public static byte[] decode(byte[] data, String keyCode) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        try {
            // 获取密钥Key
            Key k = toKey(getKey(keyCode));
            // 创建密码器(算法，工作模式，填充方式)
            Cipher cipher = Cipher.getInstance(ALGORITHM+"/ECB/PKCS5Padding");
            // 初始化密码器，设置为加密模式
            cipher.init(Cipher.DECRYPT_MODE, k);
            // 加密原数据
            return cipher.doFinal(data);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }

    /**
     * DESede加密
     * @param text 源数据
     * @param keyCode
     * @return 加密数据
     */
    public static String encode(String text, String keyCode) {
        try {
            return Base64Util.encodeUrl(encode(text.getBytes("utf-8"), keyCode));
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }

    /**
     * DESede解密
     * @param text 加密数据
     * @param keyCode
     * @return 源数据
     *
     */
    public static String decode(String text, String keyCode) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        try {
            return new String(decode(Base64Util.decode(text), keyCode),"utf-8");
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }
}
