package cn.dolphin.core.sec;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;


/**
 * Blowfish 对称加密(单密钥算法，密钥可用于加密解密)
 *
 */
@SuppressWarnings("all")
public class BlowfishUtil {

    /**
     * 加密算法
     */
    public static String ALGORITHM = "Blowfish";

    /**
     * 密钥长度
     */
    public static int KEY_SIZE = 128;


    /**
     * 生成密钥
     *
     * @param keyCode
     * @return 密钥
     *
     */
    public static byte[] getKey(String keyCode) {
        try {
            // 实例化密钥生成器
            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
            // SHA1密码随机数供应者
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(keyCode.getBytes("utf-8"));
            // 初始化：AES密钥长度128、192、256位
            kg.init(KEY_SIZE, secureRandom);
            // 生成秘密密钥
            SecretKey secretKey = kg.generateKey();
            // 获得密钥的二进制编码形式
            return secretKey.getEncoded();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }


    /**
     * Blowfish加密
     *
     * @param data 源数据
     * @param keyCode
     * @return 加密数据
     *
     */
    public static byte[] encode(byte[] data, String keyCode) {
        try {
            // 还原密钥
            SecretKey secretKey = new SecretKeySpec(getKey(keyCode), ALGORITHM);
            // 创建密码器
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            // 初始化密码器，设置为加密模式
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            // 加密原数据
            return cipher.doFinal(data);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }


    /**
     * Blowfish解密
     * @param data 加密数据
     * @param keyCode
     * @return 源数据
     */
    public static byte[] decode(byte[] data, String keyCode) {
        try {
            // 还原为密钥
            SecretKey secretKey = new SecretKeySpec(getKey(keyCode), ALGORITHM);
            // 创建密码器
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            // 初始化密码器，设置为解密模式
            cipher.init(Cipher.DECRYPT_MODE, secretKey);
            // 解密加密数据
            return cipher.doFinal(data);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }

    /**
     * Blowfish加密
     * @param text 源数据
     * @param keyCode
     * @return 加密数据
     */
    public static String encode(String text, String keyCode) {
        try {
            return Base64Util.encodeUrl(encode(text.getBytes("utf-8"), keyCode));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }


    /**
     * Blowfish解密
     * @param text 加密数据
     * @param keyCode
     * @return 源数据
     */
    public static String decode(String text, String keyCode) {
        try {
            return new String(decode(Base64Util.decode(text), keyCode),"utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("KEY_CODE错误");
        }
    }
}
