package cn.dolphin.core.sec;

import cn.dolphin.core.util.StrUtil;
import org.apache.commons.codec.binary.Base64;


/**
 * Base64 编码和解码
 *
 */
@SuppressWarnings("all")
public class Base64Util {

    /**
     * 编码
     * @param data
     * @return
     */
    public static String encode(byte[] data) {
        return Base64.encodeBase64String(data);
    }

    /**
     * 编码
     * @param data
     * @return
     */
    public static String encodeStr(String data) {
        return encode(StrUtil.getBytes(data));
    }

    /**
     * 编码为URL安全的字符串
     * @param data
     * @return
     */
    public static String encodeUrl(byte[] data) {
        return Base64.encodeBase64URLSafeString(data);
    }

    /**
     * 编码为URL安全的字符串
     * @param data
     * @return
     */
    public static String encodeUrlStr(String data) {
        return encodeUrl(StrUtil.getBytes(data));
    }

    /**
     * 解码
     * @param encode
     * @return
     */
    public static byte[] decode(String encode) {
        return Base64.decodeBase64(encode);
    }

    /**
     * 解码
     * @param encode
     * @return
     */
    public static String decodeStr(String encode) {
        return StrUtil.getStr(decode(encode));
    }
}
