package cn.dolphin.core.result;

import cn.dolphin.core.page.PageList;
import com.alibaba.fastjson.annotation.JSONType;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

/**
 * 分页列表返回封装类
 */
@JSONType(orders={"dec","page","data"})
@SuppressWarnings("all")
public class PageResult<T extends Collection> implements Serializable {

    private ResultSupport dec; //状态信息封装

    private T data; //存储数据和普通对象

    private PageSupport page; //分页信息

    public PageResult() {
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }

    public PageResult(boolean bool) {
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return bool;
            }
        };
    }

    public PageResult(T data,Boolean bool) {
        this(bool);
        this.dec.setCode(ResultCode.SUCCESS_CODE);
        this.dec.setMsg("success");
        this.data = data;
    }

    public PageResult(String code, String msg,Boolean bool){
        this(bool);
        dec.setCode(code);
        dec.setMsg(msg);
    }

    public PageResult(String code, String msg, T data,Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
        this.data = data;
    }


    /**
     * 封装分页结果
     * @param pageList 集合
     */
    public PageResult(PageList pageList) {
        this(pageList.getPageBean().getCurrentPage(),pageList.getPageBean().getPageSize(),pageList.getTotalPage(),pageList.getTotalCount(),(T) pageList,true);
    }

    /**
     * 封装分页结果
     * @param pageNo 当前页
     * @param pageSize 当前条数
     * @param pageCount 总页数
     * @param totalCount 总数
     * @param data 集合
     */
    public PageResult(int pageNo, int pageSize, int pageCount, int totalCount, T data,Boolean bool) {
        this(bool);
        this.page = new PageSupport();
        this.dec.setCode(ResultCode.SUCCESS_CODE);
        this.dec.setMsg("success");
        this.page.setNumber(pageNo);
        this.page.setSize(pageSize);
        this.page.setPage(pageCount);
        this.page.setTotal(totalCount);
        this.data = data;
    }


    /**
     * 接口调用成功,有返回对象
     * @param data 集合
     * @return
     */
    public static <T extends Collection> PageResult<T> success(T data) {
        if(data instanceof PageList){
            return new PageResult<T>((PageList)data);
        }
        return new PageResult<T>( data,true);
    }

//    /**
//     * 接口调用成功,有返回对象
//     * @param data 集合
//     * @return
//     */
//    public static <T extends Collection> PageResult<T> success(PageList pageList) {
//        return new PageResult<T>(pageList);
//    }


    /**
     * 接口调用成功,有返回对象
     * @param pageNo 当前页
     * @param pageSize 当前条数
     * @param pageCount 总页数
     * @param totalCount 总数
     * @param data 集合
     * @return
     */
    public static <T extends Collection> PageResult<T> success(int pageNo, int pageSize, int pageCount, int totalCount, T data) {
        return new PageResult<T>(pageNo, pageSize, pageCount, totalCount, data,true);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,有返回对象
     * @param code
     * @param message
     * @param data
     * @return
     */
    public static <T extends Collection> PageResult<T> error(String code, String message, T data) {
        return new PageResult<T>(code, message, data,false);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,没有返回对象
     * @param code
     * @param message
     * @return
     */
    public static <T extends Collection> PageResult<T> error(String code, String message) {
        return new PageResult<T>(code, message,false);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,没有返回对象
     * @return
     */
    public static <T extends Collection> PageResult<T> error() {
        return new PageResult<T>(ResultCode.ERROR_CODE, "fail",false);
    }


    public ResultSupport getDec() {
        //object 为空返回空{}
        if(dec == null){
            ResultSupport obj= new ResultSupport() {
                @Override
                public boolean isSuccess() {
                    return false;
                }
            };
            return obj ;
        }
        return dec;
    }
    public void setDec(ResultSupport dec) {
        this.dec = dec;
    }

    public T getData() {
        //list 为空返回空数组
        if(data == null){
            return (T) Collections.emptyList();
        }
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public PageSupport getPage() {
        return page;
    }

    public void setPage(PageSupport page) {
        this.page = page;
    }


}
