package cn.dolphin.core.result;

import cn.dolphin.core.json.FastJsonUtil;
import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;

/**
 * 异常返回封装类
 */
@Data
@JSONType(orders={"dec","data"})
@SuppressWarnings("all")
public class FailResult implements Serializable {

    private static final String SERVLET = "000400"; //接口错误
    private static final String PARAM_ERROR = "000405"; //参数错误
    private static final String NO_FOUND = "000404"; //没有找到资源
    private static final String SERVER_ERROR = "000500"; //服务器异常
    private static final String NO_PERMISSION = "000501"; //没有权限

    public static final String ERROR_101000 = "101000";//[服务器]运行时异常
    public static final String ERROR_101001 = "101001";//[服务器]空指针异常
    public static final String ERROR_101002 = "101002";//[服务器]数据类型转换异常
    public static final String ERROR_101003 = "101003";//[服务器]IO异常
    public static final String ERROR_101004 = "101004";//[服务器]未知方法异常
    public static final String ERROR_101005 = "101005";//[服务器]数组越界异常
    public static final String ERROR_101006 = "101006";//[服务器]网络异常

    private ResultSupport dec; //状态信息封装

    private Object data; //存储数据和普通对象

    public FailResult() {
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }

    public FailResult(String code, String msg){
        this();
        dec.setCode(code);
        dec.setMsg(msg);
    }

    public static FailResult paramError() {
        return new FailResult(PARAM_ERROR, "[服务器]参数错误");
    }

    public static FailResult paramError(String msg) {
        return new FailResult(PARAM_ERROR, msg);
    }

    public static FailResult serverError() {
        return new FailResult(SERVER_ERROR, "[服务器]服务器异常");
    }

    public static FailResult noFound() {
        return new FailResult(NO_FOUND, "[服务器]未找到对应的资源");
    }

    public static FailResult noFound(String msg) {
        return new FailResult(NO_FOUND, msg);
    }

    public static FailResult noPermission() {
        return new FailResult(NO_PERMISSION, "[服务器]没有权限");
    }

    public static FailResult serviceError(String code,String msg){ return new FailResult(code,msg); }

    public static FailResult ServletError(){ return new FailResult(SERVLET, "[服务器]接口错误"); }

    public String toJSONString() {
        return FastJsonUtil.toString(this);
    }

    public ResultSupport getDec() {
        //object 为空返回空{}
        if(dec == null){
            ResultSupport obj= new ResultSupport() {
                @Override
                public boolean isSuccess() {
                    return false;
                }
            };
            return obj ;
        }
        return dec;
    }

    public void setDec(ResultSupport dec) {
        this.dec = dec;
    }

    public Object getData() {
        //object 为空返回空{}
        if(data == null){
            Object obj= new Object();
            return obj ;
        }
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }


}
