package cn.dolphin.core.result;

import cn.dolphin.core.json.FastJsonUtil;
import com.alibaba.fastjson.annotation.JSONType;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

/**
 * 数组或者集合
 */
@SuppressWarnings("all")
@JSONType(orders={"dec","data","total"})
public class ArrayResult<T extends Collection> implements Serializable {

    private ResultSupport dec; //状态信息封装

    private T data; //存储数据和普通对象

    private Integer total = 0; // 总数

    public ArrayResult(){
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }


    public ArrayResult(boolean bool) {
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return bool;
            }
        };
    }

    public ArrayResult(T data,Boolean bool) {
        this(bool);
        this.dec.setCode(ResultCode.SUCCESS_CODE);
        this.dec.setMsg("success");
        this.data = data;
    }

    public ArrayResult(String code, String msg,Boolean bool){
        this(bool);
        dec.setCode(code);
        dec.setMsg(msg);
    }

    public ArrayResult(String code, String msg, T data,Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
        this.data = data;
    }

    /**
     * 封装结果
     * @param data 集合
     * @param totalCount 总数
     */
    public ArrayResult(T data,int totalCount,Boolean bool) {
        this(bool);
        this.dec.setCode(ResultCode.SUCCESS_CODE);
        this.dec.setMsg("success");
        this.total = totalCount;
        this.data = data;
    }


    /**
     * 接口调用成功,有返回对象
     * @param data 集合
     * @return
     */
    public static <T extends Collection> ArrayResult<T> success(T data) {
        return new ArrayResult<T>( data,true);
    }

    /**
     * 接口调用成功,有返回对象
     * @param data 集合
     * @param totalCount 总数
     * @return
     */
    public static <T extends Collection> ArrayResult<T> success(T data,int totalCount) {
        return new ArrayResult<T>(data,totalCount,true);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,有返回对象
     * @param code
     * @param message
     * @param data
     * @return
     */
    public static <T extends Collection> ArrayResult<T> error(String code, String message, T data) {
        return new ArrayResult<T>(code, message, data,false);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,没有返回对象
     * @param message
     * @param message
     * @return
     */
    public static <T extends Collection> ArrayResult<T> error(String message) {
        return new ArrayResult<T>(ResultCode.ERROR_CODE, message,false);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,没有返回对象
     * @param code
     * @param message
     * @return
     */
    public static <T extends Collection> ArrayResult<T> error(String code, String message) {
        return new ArrayResult<T>(code, message,false);
    }

    /**
     * 接口调用失败,有错误字符串码和描述,没有返回对象
     * @return
     */
    public static <T extends Collection> ArrayResult<T> error() {
        return new ArrayResult<T>(ResultCode.ERROR_CODE, "fail",false);
    }
    @Override
    public String toString() {
        return FastJsonUtil.toString(this);
    }


    public ResultSupport getDec() {
        //object 为空返回空{}
        if(dec == null){
            ResultSupport obj= new ResultSupport() {
                @Override
                public boolean isSuccess() {
                    return false;
                }
            };
            return obj ;
        }
        return dec;
    }
    public void setDec(ResultSupport dec) {
        this.dec = dec;
    }

    public T getData() {
        //list 为空返回空数组
        if(data == null){
            return (T) Collections.emptyList();
        }
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }
}
