package cn.dolphin.core.result;


import com.alibaba.fastjson.annotation.JSONType;
import lombok.Data;

import java.io.Serializable;

/**
 * 对象返回封装类
 */
@Data
@JSONType(orders={"dec","data"})
@SuppressWarnings("all")
public class ApiResult implements Serializable {
    private ResultSupport dec ; //状态信息封装
    private Object data; //存储数据和普通对象

    public ApiResult(){
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return false;
            }
        };
    }

    public ApiResult(boolean bool) {
        this.dec = new ResultSupport() {
            @Override
            public boolean isSuccess() {
                return bool;
            }
        };
    }

//    public ApiResult(String code, String msg){
//        this();
//        dec.setCode(code);
//        dec.setMsg(msg);
//    }

    public ApiResult(String code, String msg,Boolean bool){
        this(bool);
        dec.setCode(code);
        dec.setMsg(msg);
    }

    public ApiResult(String code, String msg, Object data,Boolean bool) {
        this(bool);
        this.dec.setCode(code);
        this.dec.setMsg(msg);
        this.data = data;
    }

    /**
     * 成功请求返回
     * @return
     */
    public static ApiResult success() {
        return new ApiResult(ResultCode.SUCCESS_CODE, "success",true);
    }

    /**
     * 成功请求返回
     * @param code 编码
     * @param msg 传递提示信息
     * @return
     */
    public static ApiResult success(String code,String msg) {
        return new ApiResult(code, msg,true);
    }


    /**
     * 成功请求返回
     * @param msg 传递提示信息
     * @return
     */
    public static ApiResult success(String msg) {
        return new ApiResult(ResultCode.SUCCESS_CODE, msg,true);
    }


    /**
     * 成功请求返回
     * @param data 传递数据
     * @return
     */
    public static ApiResult success(Object data) {
        return new ApiResult(ResultCode.SUCCESS_CODE, "success", data,true);
    }

    /**
     * 成功请求返回
     * @param msg 传递提示信息
     * @param data 数据
     * @return
     */
    public static ApiResult success(String msg,Object data) {
        return new ApiResult(ResultCode.SUCCESS_CODE, msg,data,true);
    }

    /**
     * 成功请求返回
     * @param code 编码
     * @param msg 传递提示信息
     * @param data 数据
     * @return
     */
    public static ApiResult success(String code,String msg,Object data) {
        return new ApiResult(code, msg,data,true);
    }

    /**
     * 失败请求返回
     * @return
     */
    public static ApiResult error(){
        return new ApiResult(ResultCode.ERROR_CODE, "fail",false);
    }

    /**
     * 失败请求返回
     * @param msg 传递提示信息
     * @return
     */
    public static ApiResult error(String msg) {
        return new ApiResult(ResultCode.ERROR_CODE, msg,false);
    }

    /**
     * 失败请求返回
     * @param code 状态编码
     * @param msg 传递提示信息
     * @return
     */
    public static ApiResult error(String code,String msg) {
        return new ApiResult(code, msg,false);
    }

    /**
     * 失败请求返回
     * @param msg 传递提示信息
     * @return
     */
    public static ApiResult error(String code,String msg,Object data) {
        return new ApiResult(code, msg,data,false);
    }

    public ResultSupport getDec() {
        //object 为空返回空{}
        if(dec == null){
            ResultSupport obj= new ResultSupport() {
                @Override
                public boolean isSuccess() {
                    return false;
                }
            };
            return obj ;
        }
        return dec;
    }

    public void setDec(ResultSupport dec) {
        this.dec = dec;
    }

    public Object getData() {
        //object 为空返回空{}
        if(data == null){
            Object obj= new Object();
            return obj ;
        }
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "ApiResult{" +
                "dec=" + dec +
                ", data=" + data +
                '}';
    }
}
