package cn.dolphin.core.regex;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 数值类型正则
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class NumberRegex {

    /**
     * 匹配非负整数（正整数 / 0）
     */
    public final static String NONNEGATIVE_INTEGER = "^\\d+$";

    /**
     * 匹配正整数
     */
    public final static String POSITIVE_INTEGER = "^[1-9]{1}[0-9]*$";

    /**
     * 匹配非正整数（负整数  + 0）
     */
    public final static String NO_POSITIVE_INTEGER = "^((-\\d+) ?(0+))$";

    /**
     * 匹配负整数
     */
    public final static String NEGATIVE_INTEGER = "^-[1-9]{1}[0-9]*$";

    /**
     * 匹配整数
     */
    public final static String INTEGER = "^-?\\d+$";

    /**
     * 匹配非负浮点数（正浮点数 + 0）
     */
    public final static String NONNEGATIVE_FLOAT = "^\\d+(\\.\\d+)?$";

    /**
     * 匹配正浮点数
     */
    public final static String POSITIVE_FLOAT = "^(([0-9]+\\.[0-9]*[1-9][0-9]*) ?([0-9]*[1-9][0-9]*\\.[0-9]+) ?([0-9]*[1-9][0-9]*))$";

    /**
     * 匹配非正浮点数（负浮点数 + 0）
     */
    public final static String NO_POSITIVE_FLOAT = "^((-\\d+(\\.\\d+)?) ?(0+(\\.0+)?))$";

    /**
     * 匹配负浮点数
     */
    public final static String NEGATIVE_FLOAT = "^(-(([0-9]+\\.[0-9]*[1-9][0-9]*) ?([0-9]*[1-9][0-9]*\\.[0-9]+) ?([0-9]*[1-9][0-9]*)))$";

    /**
     * 匹配浮点数
     */
    public final static String FLOAT = "^(-?\\d+)(\\.\\d+)?$";
}
