package cn.dolphin.core.regex;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;


/**
 * 基础常规正则
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class CoreRegex {

    /** 验证密码(数字和英文同时存在) */
    public static final String V_PASSWORD_REG = "[A-Za-z]+[0-9]";

    /** 验证密码长度(6-18位) */
    public static final String V_PASSWORD_LENGTH = "^\\d{6,32}$";

    /** 验证两位数 */
    public static final String V_TWO＿POINT = "^[0-9]+(.[0-9]{2})?$";

    /** 验证一个月的31天 */
    public static final String V_31DAYS = "^((0?[1-9])|((1|2)[0-9])|30|31)$";

    /** 用来用户注册。匹配由数字、26个英文字母或者下划线组成的字符串 */
    public static final String V_USERNAME = "^\\w+$";

    /** 匹配邮箱验证码 */
    public final static String EMAIL_CODE = "^[0-9]{6}$";
    /** 匹配图片验证码 */
    public final static String IMG_CODE = "^[0-9]{4}$";

    /** 匹配邮箱验证码 */
    public final static String SMS_CODE = "^[0-9]{6}$";

    /** 匹配email地址 */
    public final static String EMAIL = "^[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+$";

    /** 匹配url */
    public final static String URL = "^[a-zA-z]+://(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*(\\?\\S*)?$";

    /** 匹配中文字符 */
    public final static String CHINESE = "[\\u4e00-\\u9fa5]";

    /** 匹配双字节字符(包括汉字在内) */
    public final static String ANY = "[^\\x00-\\xff]";

    /** 匹配空行 */
    public final static String NULL_LINE = "\\n[\\s?]*\\r";

    /** 非空 */
    public static final String V_NOTEMPTY = "^\\S+$";

    /** 常用正则表达式：匹配国内电话号码，匹配形式如 0511-4405222 或 021-87888822 */
    public final static String TELEPHONE = "^\\d{3,4}-\\d{7,8}$";

    /** 腾讯QQ号, 腾讯QQ号从10000开始 */
    public final static String QQ = "^[1-9][0-9]{4,11}$";

    /** 匹配中国邮政编码 */
    public final static String POSTBODY = "^[1-9]\\d{5}(?!\\d)$";

    /** 匹配身份证, 中国的身份证为15位或18位 */
    public final static String ID_CARD = "^\\d{15}(\\w{3})?$";

    /** IP */
    public final static String IP = "^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$";
//    /** ip地址 */
//    public static final String V_IP4 = "^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)$";

    /** 手机号 */
    public final static String MOBILE = "^1[345678][0-9]{9}$";
//    /** 手机 */
//    public static final String V_MOBILE = "^(1)[0-9]{10}$";

    /** 银行卡 */
    public final static String BANK_NO = "^\\d{12,20}$";

    /** 注释符号，用于通过str.replaceAll去除字符串中的注释 */
    public final static String COMMENT = "/\\*[\\s\\S]*?\\*/";

    /** 清除html标签 */
    public static final String RE_HTML_MARK = "(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)";

    /** 图片 */
    public static final String V_PICTURE = "(.*)\\.(jpg|bmp|gif|ico|pcx|jpeg|tif|png|raw|tga)$";

    /** 压缩文件 */
    public static final String V_RAR = "(.*)\\.(rar|zip|7zip|tgz)$";

    /** 视频 */
    public static final String VIDEO = ".+(.mp4|.MP4|.avi|.AVI|.mov|.MOV|.rmvb|.RMVB|.wmv|.WMV)$";

    /** 文本 */
    public static final String TEXT = ".+(.pdf|.PDF|.txt|.TXT|.doc|.DOC)$";

    /** 日期 */
    public static final String V_DATE = "^((((1[6-9]|[2-9]\\d)\\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\\d|3[01]))|(((1[6-9]|[2-9]\\d)\\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\\d|30))|(((1[6-9]|[2-9]\\d)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|(((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\\d):[0-5]?\\d:[0-5]?\\d$";



}
