package cn.dolphin.core.regex;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 字母类型的匹配
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class AlphabetRegex {
    /** 匹配由26个英文字母组成的字符串 */
    public final static String ALPHABET = "^[A-Za-z]+$";

    /** 匹配由26个英文字母的大写组成的字符串 */
    public final static String BIG_ALPHABET = "^[A-Z]+$";

    /** 匹配由26个英文字母的小写组成的字符串 */
    public final static String LOW_ALPHABET = "^[a-z]+$";

    /** 匹配由数字和26个英文字母组成的字符串 */
    public final static String ALPHABET_NUM = "^[A-Za-z0-9]+$";
}
