package cn.dolphin.core.redis;


import cn.dolphin.core.exception.ApiException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/***
 * Redis分布式锁,可用于多线程竞争资源控制，以及防止重复提交表单等操作
 */
@Slf4j
@Component
public class RedisLock {

    /**
     * 加锁
     *
     * @param key
     * @param value 当前时间 + 超时时间
     * @return
     */
    public static boolean lock(String key, String value) {
        if (RedisBean.getInstance().getRedisTemplate().opsForValue().setIfAbsent(key, value)) {
            return true;
        }
        String currentValue = (String) RedisBean.getInstance().getRedisTemplate().opsForValue().get(key);
        //如果锁过期
        if (!StringUtils.isEmpty(currentValue)
                && Long.parseLong(currentValue) < System.currentTimeMillis()) {
            //获取上一个锁的时间
            String oldValue = (String) RedisBean.getInstance().getRedisTemplate().opsForValue().getAndSet(key, value);
            if (!StringUtils.isEmpty(oldValue) && oldValue.equals(currentValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 解锁
     *
     * @param key
     * @param value
     */
    public static void unlock(String key, String value) {
        try {
            String currentValue = (String) RedisBean.getInstance().getRedisTemplate().opsForValue().get(key);
            if (!StringUtils.isEmpty(currentValue) && currentValue.equals(value)) {
                RedisBean.getInstance().getRedisTemplate().opsForValue().getOperations().delete(key);
            }
        } catch (Exception e) {
            //log.error("redis分布式锁,解锁异常,{}", e);
            throw new ApiException("redis分布式锁,解锁异常,{}",e);
        }
    }
}
