package cn.dolphin.core.queue;

import cn.dolphin.core.bean.DataBean;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 * 数据队列缓存类
 */
@SuppressWarnings("all")
public class DataQueueStack {

    private BlockingQueue<DataBean> dataQueue = null;

    public DataQueueStack() {
        //初始化队列
        dataQueue = new LinkedBlockingQueue<DataBean>(10000); //队列容纳量
    }

    /**
     * 添加数据到队列
     *
     * @param dataBean
     * @return
     */
    public boolean doOfferData(DataBean dataBean) {

        try {
            return dataQueue.offer(dataBean, 2, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 获取队列数据
     *
     * @return
     */
    public DataBean doPollData() {

        try {
            return dataQueue.poll(2, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取队列中的个数
     *
     * @return
     */
    public int doGetQueueCount() {
        return dataQueue.size();
    }

}
