package cn.dolphin.core.plugin.baidu;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

/**
 * 百度地图API
 */
@Slf4j
public class BaiduMapApi {

    private  static String accessKey = "gV7ex9D4tvMxataH82p4B1ULD8hL2oKW";//百度AK

    private static final String LAT = "lat"; //纬度值
    private static final String LNG = "lng";    //经度值
    private static InputStreamReader isr = null;


    /**
     * Baidu地图通过地址获取经纬度
     */
    public  static Map<String, Double> getLatAndLng(String address) {
        Map<String, Double> lngAnglatMap = new HashMap<String, Double>();
        StringBuilder url = new StringBuilder("http://api.map.baidu.com/geocoder/v2/?address=").append(address)
                .append("&output=json&ak=").append(accessKey);
        try {
            String json = loadJSON(url.toString());
            JSONObject object = JSONObject.parseObject(json);
            //状态码
            String statusCode = object.getInteger("status").toString();
            if ("0".equals(statusCode)) {
                double lng = object.getJSONObject("result").getJSONObject("location").getDouble(LNG);
                lngAnglatMap.put("lng", lng);
                double lat = object.getJSONObject("result").getJSONObject("location").getDouble(LAT);
                lngAnglatMap.put("lat", lat);
            } else {
                log.warn("BaiduMapService", "百度接口服务状态码错误：" + statusCode);
            }
        } catch (Exception e) {
            log.error("BaiduMapService", e);
        }
        return lngAnglatMap;
    }

    private static String loadJSON(String url) {
        String json = null;
        try {
            URL mapAPI = new URL(url);
            URLConnection connection = mapAPI.openConnection();
            isr = new InputStreamReader(connection.getInputStream(), "utf-8");
            json= IOUtils.toString(isr);
        } catch (Exception e) {
            log.error("BaiduMapService", e);
        } finally {
            try {
                isr.close();
            } catch (IOException e) {
                log.error("BaiduMapService", e);
            }
        }
        return json;
    }

//    public static void main(String[] args)throws Exception {
//        Map<String, Double> location = getLatAndLng("江苏省苏州吴中区晋合广场");
//        System.out.println(location);
//    }


}
