package cn.dolphin.core.page.cache;

import cn.dolphin.core.exception.DaoRuntimException;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Constructor;
import java.util.Properties;

@SuppressWarnings("all")
public abstract class CacheFactory {

    /**
     * 创建 SQL 缓存
     *
     * @param cacheClass
     * @return
     */
    public static <K, V> Cache<K, V> createCache(String cacheClass, String prefix, Properties properties) {
        if (StringUtils.isEmpty(cacheClass)) {
            cacheClass = "com.google.common.cache.Cache";
            try {
                Class.forName(cacheClass);
                return new GuavaCache<K, V>(properties, prefix);
            } catch (Throwable t) {
                throw new DaoRuntimException("Created cache [" + cacheClass + "] Error", t);
            }
        } else {
            try {
                @SuppressWarnings("unchecked")
                Class<? extends Cache<K, V>> clazz = (Class<? extends Cache<K, V>>) Class.forName(cacheClass);
                try {
                    Constructor<? extends Cache<K, V>> constructor = clazz
                            .getConstructor(Properties.class, String.class);
                    return constructor.newInstance(properties, prefix);
                } catch (Exception e) {
                    return clazz.newInstance();
                }
            } catch (Throwable t) {
                throw new DaoRuntimException("Created Cache [" + cacheClass + "] Error", t);
            }
        }
    }
}
