package cn.dolphin.core.page;

import cn.dolphin.core.dto.Dto;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.web.util.RequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 功能：对http请求进行封装，用于查询。<br>
 *
 * 具体功能如下：<br>
 * 1.将查询条件封装成Map对象。<br>
 * 2.封装分页参数构建PageBean 。<br>
 * 3.封装排序条件。<br>
 *
 */
public class QueryFilter {

    private Logger logger = LoggerFactory.getLogger(QueryFilter.class);

    /**
     * 过滤参数
     */
    private Map<String, Object> filters = new HashMap<String, Object>();

    /**
     * 排序列
     */
    private String sortColumns = "";


    private PageBean pageBean = null;


    private HttpServletRequest request;

    public QueryFilter(Map<String, Object> map){
        this(map,true,true);
    }
    public QueryFilter(Dto dto){
        this(dto,true,true);
    }

    public QueryFilter(Map<String, Object> map, boolean needPage){
        this(map,needPage,true);
    }

    public QueryFilter(Dto dto, boolean needPage){
        this(dto,needPage,true);
    }

    public QueryFilter(Map<String, Object> map, boolean needPage,boolean showTotal){
        if (needPage) {
            int page = MapUtil.getInteger(map, "page", 1);
            int pageSize = MapUtil.getInteger(map, "pageSize", 10);
            this.pageBean = new PageBean(page, pageSize);
            this.pageBean.setShowTotal(showTotal);
        }
        filters = map;
    }


    public QueryFilter(Dto dto, boolean needPage, boolean showTotal){
        if (needPage) {
            int page = MapUtil.getInteger(dto, "page", 1);
            int pageSize = MapUtil.getInteger(dto, "pageSize", 10);
            this.pageBean = new PageBean(page, pageSize);
            this.pageBean.setShowTotal(showTotal);
        }
        filters = dto;
    }

    public QueryFilter(Dto dto, int page, int pageSize){
        this(dto,page,pageSize,true);
    }

    public QueryFilter(Map<String, Object> map, int page, int pageSize){
        this(map,page,pageSize,true);
    }

    public QueryFilter(Map<String, Object> map, int page, int pageSize,boolean showTotal){
        this.pageBean = new PageBean(page, pageSize);
        this.pageBean.setShowTotal(showTotal);
        filters = map;
    }

    public QueryFilter(Dto dto, int page, int pageSize,boolean showTotal){
        this.pageBean = new PageBean(page, pageSize);
        this.pageBean.setShowTotal(showTotal);
        filters = dto;
    }

    public QueryFilter(HttpServletRequest request, boolean needPage) {
        this.request = request;
        try {
            if (needPage) {
                int page = RequestUtil.getInt(request, "page", 1);
                int pageSize = RequestUtil.getInt(request, "pageSize", 10);
                this.pageBean = new PageBean(page, pageSize);
                this.pageBean.setShowTotal(true);
            }
            Map<String, Object> map = RequestUtil.getParams(request);
            filters = map;
        } catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }


    /**
     * 添加过滤字段条件
     *
     * @param filterName
     *            参数名
     * @param params
     *            参数值
     */
    public void addFilter(String filterName, Object params) {
        this.filters.put(filterName, params);
    }

    public Map<String, Object> getFilters() {
        return filters;
    }

    public void setFilters(Map<String, Object> filters) {
        this.filters = filters;
    }

    public String getSortColumns() {
        return sortColumns;
    }

    public void setSortColumns(String sortColumns) {
        this.sortColumns = sortColumns;
    }

    public PageBean getPageBean() {
        return pageBean;
    }

    public void setPageBean(PageBean pageBean) {
        this.pageBean = pageBean;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }


}
