package cn.dolphin.core.page;

import cn.dolphin.core.consts.Constants;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.map.ThreadMapUtil;

/**
 * 分页参数自动获取
 */
public class PageSupport {

    /**
     * 封装分页对象
     */
    public static PageBean getPageBean() {
        PageBean pageBean = new PageBean();
//        pageBean.setCurrentPage(MapUtil.getInteger(BodyCacheHttpServletRequestWrapper.getParamsMap(RequestThreadLocal.getRequest()),Constants.PAGE_NUM,1));
//        pageBean.setPagesize(MapUtil.getInteger(BodyCacheHttpServletRequestWrapper.getParamsMap(RequestThreadLocal.getRequest()),Constants.PAGE_SIZE,10));
        //从线程隔离缓存map取值
        pageBean.setCurrentPage(MapUtil.getInteger(ThreadMapUtil.get(),Constants.PAGE_NUM,1));
        pageBean.setPagesize(MapUtil.getInteger(ThreadMapUtil.get(),Constants.PAGE_SIZE,10));
        return pageBean;
    }

    /**
     * 初始化
     * @return
     */
    public static PageBean buildPageRequest(){
        return getPageBean();
    }
}
