package cn.dolphin.core.mybatis.util;

import cn.dolphin.core.mybatis.enums.CodeBaseEnum;

/**
 * 兼容枚举类型工具类
 */
public class CodeEnumUtil {
    /**
     * @param enumClass
     * @param code
     * @param <E>
     * @return
     */
    public static <E extends Enum<?> & CodeBaseEnum> E codeOf(Class<E> enumClass, int code) {
        E[] enumConstants = enumClass.getEnumConstants();
        for (E e : enumConstants) {
            if (e.code() == code)
                return e;
        }
        return null;
    }
}
