package cn.dolphin.core.mybatis.typehandler;

import cn.dolphin.core.json.FastJsonUtil;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 扩展mybatis支持json格式
 * 配置mapper.xml：
 * <result typeHandler="cn.dolphin.core.mybatis.typehandler.JsonTypeHandler"/>
 */
public class JsonTypeHandler extends BaseTypeHandler<Object> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, FastJsonUtil.writeValue(parameter));
    }

    @Override
    public Object getNullableResult(ResultSet rs, String columnName)
            throws SQLException {
        return FastJsonUtil.readValue(rs.getString(columnName), Object.class);
    }

    @Override
    public Object getNullableResult(ResultSet rs, int columnIndex)
            throws SQLException {
        return FastJsonUtil.readValue(rs.getString(columnIndex), Object.class);
    }

    @Override
    public Object getNullableResult(CallableStatement cs, int columnIndex)
            throws SQLException {
        return FastJsonUtil.readValue(cs.getString(columnIndex), Object.class);
    }

}
