package cn.dolphin.core.mybatis.typehandler;

import cn.dolphin.core.util.EmptyUtil;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;

@MappedJdbcTypes({JdbcType.INTEGER})
@MappedTypes({Object.class})
public class IntegerTypeHandler extends BaseTypeHandler<Object> {

    private static Logger logger = LoggerFactory.getLogger(IntegerTypeHandler.class);

    @Override
    public Object getNullableResult(ResultSet resultSet, String arg1) throws SQLException {
        return resultSet.getInt(arg1);
    }

    @Override
    public Object getNullableResult(ResultSet resultSet, int arg1) throws SQLException {
        return resultSet.getInt(arg1);
    }

    @Override
    public Object getNullableResult(CallableStatement callableStatement, int arg1) throws SQLException {
        return callableStatement.getInt(arg1);
    }

    @Override
    public void setNonNullParameter(PreparedStatement preparedStatement, int arg1, Object arg2, JdbcType arg3) throws SQLException {
        Integer value = null;
        if(EmptyUtil.isNotEmpty(arg2)){
            if(arg2 instanceof Integer){
                value = (Integer)arg2;
            }else if(arg2 instanceof Long){
                value = (Integer)arg2;
            }else if(arg2 instanceof String){
                try {
                    value = Integer.parseInt(arg2.toString());
                } catch (NumberFormatException e) {
                    logger.error("转换失败!返回null",e);
                    value = null;
                }
            }
        }
        if(null==value) {
            preparedStatement.setNull(arg1, Types.INTEGER);
        }else {
            preparedStatement.setInt(arg1, value);
        }
    }

}
