package cn.dolphin.core.mybatis.typehandler;

import cn.dolphin.core.util.EmptyUtil;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.*;


@MappedJdbcTypes({JdbcType.FLOAT})
@MappedTypes({Object.class})
public class FloatTypeHandler extends BaseTypeHandler<Object> {

    private static Logger logger = LoggerFactory.getLogger(FloatTypeHandler.class);

    @Override
    public Object getNullableResult(ResultSet resultSet, String arg1) throws SQLException {
        return resultSet.getFloat(arg1);
    }

    @Override
    public Object getNullableResult(ResultSet resultSet, int arg1) throws SQLException {
        return resultSet.getFloat(arg1);
    }

    @Override
    public Object getNullableResult(CallableStatement callableStatement, int arg1) throws SQLException {
        return callableStatement.getFloat(arg1);
    }

    @Override
    public void setNonNullParameter(PreparedStatement preparedStatement, int arg1, Object arg2, JdbcType arg3) throws SQLException {
        Float value = null;
        if(EmptyUtil.isNotEmpty(arg2)){
            if(arg2 instanceof Float){
                value = (Float)arg2;
            }else if(arg2 instanceof String){
                try {
                    value = Float.parseFloat(arg2.toString());
                } catch (NumberFormatException e) {
                    logger.error("转换失败!返回null",e);
                    value = null;
                }
            }
        }
        if(null==value) {
            preparedStatement.setNull(arg1, Types.FLOAT);
        }else {
            preparedStatement.setFloat(arg1, value);
        }
    }


}
