package cn.dolphin.core.mybatis.enums;

/**
 * 性别
 */
public enum SexEnum implements CodeBaseEnum {
    UNKNOWN(0,"未知"),
    MAN(1, "男"),
    WOMAN(2, "女");

    private final int code;
    private final String desc;

    SexEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * Gets enum.
     *
     * @param code the code
     *
     * @return the enum
     */
    public static SexEnum getEnum(int code) {
        for (SexEnum ele : SexEnum.values()) {
            if (ele.code()==(code)) {
                return ele;
            }
        }
        return SexEnum.UNKNOWN;
    }

}
