MyBatis caches
===========================
![mybatis-logo](http://mybatis.github.io/images/mybatis-logo.png)

MyBatis-Hazelcast extension Hazelcast support for MyBatis Cache.

Ehcache
----------
 1.配置项目的mybatis的sql配置文件，如：
```xml
<mapper namespace="xxx">
     <cache type="cn.dolphin.core.mybatis.caches.ehcache.EhcacheCache"/>
    ……
</mapper>
```
hazelcast-cache
----------

#### 将hazelcast\bin\hazelcast.xml复制到项目的根目录里面
 1.配置项目的mybatis的sql配置文件，如：
```xml
<mapper namespace="xxx">
    <cache type="cn.dolphin.core.mybatis.caches.hazelcast.HazelcastCache" />
    ……
</mapper>
```
 2.修改hazelcast.xml：
```xml
<multicast enabled="false">
#将multicast设为false
<tcp-ip enabled="true">
    <interface>192.168.1.91</interface>
    <interface>192.168.1.92</interface>
</tcp-ip>
#将tcp-ip设置为true，分别将项目部署到这两台服务器上可现实分布式缓存。
<map name="default">
    <eviction-policy>LFU</eviction-policy>
    <max-size policy="PER_NODE">10000</max-size>
    <time-to-live-seconds>600</time-to-live-seconds>
    <max-idle-seconds>300</max-idle-seconds>
</map>
#LFU表示最不经常使用的，
#10000表示map的最大容量，
#600表示存活时间（单位秒）
#300表示最大空闲时间（单位秒）
<management-center enabled="true">http://192.168.1.91:8080/mancenter-3.1.7</management-center>
#这是hazelcast的管理界面，需要将hazelcast\mancenter-3.1.7.war放到tomcat\webapps并运行tomcat。
#其它可以是默认配置。
```
在192.168.1.91和192.168.1.92分别部署项目并运行tomcat，
这时登录http://192.168.1.91:8080/mancenter-3.1.7
会发现有两个接点，说明运行正常。然后访问项目，查询的数据会缓存到内存中。这时查看管理界面，基本上每个接点都会有缓存，如果关掉某个tomcat，那么关掉那个的缓存数据会备份到活着的服务器中。如果启动之前关闭的tomcat，那么之前活着的服务器会分担一些缓存数据给这台服务器。
