package cn.dolphin.core.map;

import cn.dolphin.core.date.DateFormatUtil;
import cn.dolphin.core.util.StrUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/**
 * 纯字符串Map
 */
public class StrHashMap extends HashMap<String, String> {

    private static final long serialVersionUID = 4845367059009179925L;

    public StrHashMap() {
    }

    public StrHashMap(Map<? extends String, ? extends String> m) {
        super(m);
    }

    public String put(String key, Object value) {
        String strValue;

        if (value == null) {
            strValue = null;
        } else if (value instanceof String) {
            strValue = (String) value;
        } else if (value instanceof Integer) {
            strValue = ((Integer) value).toString();
        } else if (value instanceof Long) {
            strValue = ((Long) value).toString();
        } else if (value instanceof Float) {
            strValue = ((Float) value).toString();
        } else if (value instanceof Double) {
            strValue = ((Double) value).toString();
        } else if (value instanceof Boolean) {
            strValue = ((Boolean) value).toString();
        } else if (value instanceof Date) {
            strValue = DateFormatUtil.formaDatetTime((Date) value);
        } else {
            strValue = value.toString();
        }
        return this.put(key, strValue);
    }

    @Override
    public String put(String key, String value) {
        if (StrUtil.areNotEmpty(key, value)) {
            return super.put(key, value);
        } else {
            return null;
        }
    }

}
