package cn.dolphin.core.map;

import cn.dolphin.core.util.StrUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 将Map的key转为驼峰
 */
public class CamelKeyMap extends HashMap {

    @Override
    public Object put(Object key, Object value) {
        key = getCamelCaseString((String)key, false);
        return super.put(key, value);
    }

    /**
     * 字段转驼峰
     * @param inputString
     * @param firstCharacterUppercase
     * @return
     */
    public static String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        if(inputString.indexOf("_")==-1){
            if(StrUtil.isFullUpperCase(inputString)){
                //如果无下划线且全为大写，转小写返回
                return inputString.toLowerCase();
            }else {
                //如果无下划线，直接返回
                return inputString;
            }
        }
        for (int i = 0; i < inputString.length(); i++) {
            char c = inputString.charAt(i);
            switch (c) {
                case '_':
                case '-':
                case '@':
                case '$':
                case '#':
                case ' ':
                case '/':
                case '&':
                    if (sb.length() > 0) {
                        nextUpperCase = true;
                    }
                    break;

                default:
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                    } else {
                        sb.append(Character.toLowerCase(c));
                    }
                    break;
            }
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Map<String,Object> map = new CamelKeyMap();
        map.put("a_name",1);
        System.out.println(map);
    }
}
