package cn.dolphin.core.jvm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

/**
 * 进程工具类
 */
public class PidUtil {

    private static final Logger LOG = LoggerFactory.getLogger(PidUtil.class);

    /**
     * 获取PID
     *
     * @return 运行的PID
     */
    public static int getPid() {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        String mxBeanName = mxBean.getName();
        int index = mxBeanName.indexOf("@");
        if (index == -1)
        {
            return 0;
        }
        return Integer.valueOf(mxBeanName.substring(0, index));
    }

    /**
     * 打印PID日志
     */
    public static void printPidLogger() {
        LOG.info("===================================================");
        int pid = getPid();
        LOG.info("Starting the program,and the pid is {}", pid);
        LOG.info("===================================================");
    }

}
