package cn.dolphin.core.jvm;

import cn.dolphin.core.bean.CpuParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * CPU参数
 */
public class CpuUtil {

    private static final Logger LOG = LoggerFactory.getLogger(CpuUtil.class);

    /**
     * 统计程序的CPU使用情况
     */
    public static CpuParam getCpuParam()
    {
        CpuParam cpuParam = new CpuParam();
        Runtime runtime = Runtime.getRuntime();
        // 获取当前电脑CPU数量
        int availableProcessors = runtime.availableProcessors();
        cpuParam.setAvailableProcessors(availableProcessors);
        // 获取java虚拟机中内存总量
        long totalMemory = runtime.totalMemory();
        cpuParam.setTotalMemory(totalMemory);
        // 获取java虚拟机中空闲内存
        long freeMemory = runtime.freeMemory();
        cpuParam.setFreeMemory(freeMemory);
        // 获取java虚拟机试图使用的最大内存量
        long maxMemory = runtime.maxMemory();
        cpuParam.setMaxMemory(maxMemory);
        LOG.info("CPU params:{}",cpuParam);
        return cpuParam;
    }
    public static void main(String[] args)
    {
        getCpuParam();
    }
}
