package cn.dolphin.core.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ValueFilter;


/**
 * 自定义jsonfilter，将null值转化为“”,避免转json后数据丢失
 */
@SuppressWarnings("all")
public class JsonFilter {

    public static final ValueFilter filter = new ValueFilter() {
        @Override
        public Object process(Object obj, String s, Object v) {
            if(v==null)
                return "";
            return v;
        }
    };

    public static void main(String[] args) {
        String result ="{\n" +
                "  \"dec\": {\n" +
                "    \"code\": \"000000\",\n" +
                "    \"msg\": \"当前应用已经存在，请勿重新添加\",\n" +
                "    \"success\": true\n" +
                "  },\n" +
                "  \"data\": {}\n" +
                "}";

        System.out.println(JSON.toJSONString(result, JsonFilter.filter));
    }
}
