package cn.dolphin.core.jdbc.support;

import cn.dolphin.core.util.CamelCaseUtil;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.lang.reflect.Field;

/**
 * 通用dao工具
 */
public class CommonObj<E>implements RowMapper<Object> {

    private Class<?> cl;

    public CommonObj(Class<?> cl) {
        this.cl = cl;
    }


    @Override
    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            Field[] fields = cl.getDeclaredFields();
            Object entity = cl.newInstance();
            for (Field f : fields) {
                f.setAccessible(true);
                this.typeMapper(f, entity, rs);
                f.setAccessible(false);
            }
            return entity;
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 转换驼峰反射对象
     * @param field
     * @param obj
     * @param rs
     * @throws Exception
     */
    private void typeMapper(Field field, Object obj, ResultSet rs) throws Exception {
        String type = field.getType().getName();
        if (type.equals("java.lang.String")) {
            field.set(obj, rs.getString(CamelCaseUtil.toUnderlineName(field.getName(),false)));
        } else if (type.equals("int") || type.equals("java.lang.Integer")) {
            field.set(obj, rs.getInt(CamelCaseUtil.toUnderlineName(field.getName(),false)));
        } else if (type.equals("long") || type.equals("java.lang.Long")) {
            field.set(obj, rs.getLong(CamelCaseUtil.toUnderlineName(field.getName(),false)));
        } else if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            field.set(obj, rs.getBoolean(CamelCaseUtil.toUnderlineName(field.getName(),false)));
        } else if (type.equals("java.util.Date")) {
            field.set(obj, rs.getDate(CamelCaseUtil.toUnderlineName(field.getName(),false)));
        } else if (type.equals("java.sql.Timestamp")){
            field.set(obj, rs.getTimestamp(CamelCaseUtil.toUnderlineName(field.getName(),false)));
        }
    }

}
