package cn.dolphin.core.jdbc.framework;

import cn.dolphin.core.jdbc.util.FrameworkDataAccessUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import javax.sql.DataSource;
import java.util.List;
import java.util.Map;


/**
 * jdbc NamedParameterJdbcTemplate 扩展工具
 * 注入datasource重写封装，采坑查询结果为null时异常解决方案
 */
public class FrameworkNamedParameterJdbcTemplate extends
        NamedParameterJdbcTemplate {

    public FrameworkNamedParameterJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public FrameworkNamedParameterJdbcTemplate(
            JdbcOperations classicJdbcTemplate) {
        super(classicJdbcTemplate);
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper)
            throws DataAccessException {

        List<T> results = getJdbcOperations().query(getPreparedStatementCreator(sql, paramSource), rowMapper);
        return FrameworkDataAccessUtil.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws DataAccessException {
        return (T) this.queryForObject(sql, (SqlParameterSource)(new MapSqlParameterSource(paramMap)), (RowMapper)(new SingleColumnRowMapper(requiredType)));
    }

    //重写解决 Assert.state(result != null, "No result map");
    @Override
    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Map<String, Object> result = (Map)this.queryForObject(sql, (SqlParameterSource)paramSource, (RowMapper)(new ColumnMapRowMapper()));
        if(null == result){
            return null;
        }

        return result;
    }

    //重写解决 Assert.state(result != null, "No result map");
    @Override
    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws DataAccessException {
        Map<String, Object> result = (Map)this.queryForObject(sql, (Map)paramMap, (RowMapper)(new ColumnMapRowMapper()));
        if(null == result){
            return null;
        }
        return result;
    }
}

