package cn.dolphin.core.jdbc.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据库字段注解
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD,ElementType.METHOD })
public @interface Field {

    /**
     * 对应数据库字段名
     *
     * @return
     */
    public String value() default "";

    /**
     * 是否只读：true-保存或更新时会忽略
     *
     * @return
     */
    public boolean readOnly() default false;

    /**
     * 是否是数据库列
     *
     * @return
     */
    public boolean isColumn() default true;

    /**
     * 是否自动解析json: true-是
     *
     * @return
     */
    public boolean isJson() default false;

    /**
     * 是否是主键: true-是
     *
     * @return
     */
    public boolean isPK() default false;

    /**
     * 格式化日期时使用，如：yyyy-MM-dd HH:mm:ss
     *
     * @return
     */
    public String format() default "";

    /**
     * 格式化数字时使用，小数位数精度
     *
     * @return
     */
    public int scale() default 0;

    /**
     * 序列名称
     * @return
     */
    public String Seq() default "";
}
