package cn.dolphin.core.jdbc;

import cn.dolphin.core.jdbc.support.IRollBack;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 事物控制
 */
@SuppressWarnings("all")
public class RollbackJdbcTemplate {

    @Resource
    private TransactionTemplate txTemplate;

    public Object executeRollBack(final IRollBack rollBack, final String script, final Map<String, Object> map) {
        return txTemplate.execute(new TransactionCallback<Object>() {
            @Override
            public Object doInTransaction(TransactionStatus status) {
                try {
                    return rollBack.execute(script, map);
                } catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                } finally {
                    status.setRollbackOnly();
                }
            }
        });
    }

}

