# IOUtil

## 介绍
&emsp;用于流处理读取关闭等操作


## 使用方式
### 一、输出流写入
```java
    OutputStream out = FileUtil.openOutputStream(file);
    IOUtil.write("你好", out);
    IOUtil.write("世界".getBytes(), out);
    IOUtil.close(out);
```
<br>

### 二、输入流转换

```java
  //输入转String、采用默认系统编码、自动关闭流
  InputStream in = FileUtil.openInputStream(file);
  System.out.println(IOUtil.toString(in));
  //输入转String、采用指定的utf8编码、自动关闭流
  in = FileUtil.openInputStream(file);
  System.out.println(IOUtil.toString(in, "utf8"));
  //输入转string、采用指定的utf8编码、设置不关闭流
  in = FileUtil.openInputStream(file);
  System.out.println(IOUtil.toString(in, "utf8", false));
  IOUtil.close(in);
  //输入转byte数组、自动关闭流
  in = FileUtil.openInputStream(file);
  System.out.println(IOUtil.toByteArray(in));
  //输入转byte数组、不自动关闭流
  in = FileUtil.openInputStream(file);
  System.out.println(IOUtil.toByteArray(in, false));
  IOUtil.close(in);
  
```
<br>

### 三、拷贝

```java
    File copyFile = new File("a.txt");
    FileUtil.createFile(copyFile);
    in = FileUtil.openInputStream(file);
    IOUtil.copy(in, FileUtil.openOutputStream(copyFile));
    System.out.println("打印copy得数据" + FileUtil.readFileToString(copyFile));
    IOUtil.close(in);
```
<br>

### 四、关闭资源、支持单个、多个关闭、关闭得资源需继承Closeable接口、比如InputStream、Outpusteam、Writer等等

```java
    in = FileUtil.openInputStream(file);
    IOUtil.close(in);
    out = FileUtil.openOutputStream(file);
    IOUtil.close(out);
    in = FileUtil.openInputStream(file);
    out = FileUtil.openOutputStream(file);
    IOUtil.close(in, out);
```
<br>
