package cn.dolphin.core.id;

import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.UUIDUtil;

/**
 * ID工具类
 */
public class ID {

    /**
     * 主机和进程的机器码
     */
    private static final Sequence WORKER = new Sequence();

    /**
     * 获取SequenceId
     * @return SequenceId
     */
    public static long getID() {
        return WORKER.nextId();
    }

    /**
     * 获取SequenceId字符串形式
     * @return SequenceId
     */
    @Deprecated
    public static String getIDStr() {
        return CastUtil.castString(WORKER.nextId());
    }

    /**
     * 获取UUID (去掉"-")
     * @return uuid
     */
    public static synchronized String getUUID32() {
        return UUIDUtil.getUUID32();
    }

    /**
     * 获取顺序的UUID(去掉"-")
     * @return
     */
    public static synchronized String getSequentialUUID32(){ return UUIDUtil.generatorUUID();}


}
