package cn.dolphin.core.freemarker;


import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import lombok.extern.slf4j.Slf4j;

import java.io.Writer;

/**
 * 模板异常处理
 */
@Slf4j
public class FreemarkerExceptionHandler implements TemplateExceptionHandler {

    @Override
    public void handleTemplateException(TemplateException e, Environment environment, Writer writer) throws TemplateException {
        FreemarkerExceptionHandler.log.error(e.getMessage(), e);
    }
}
