# FileUtil

## 介绍
&emsp;文件工具类，主要用于文件的添加、移动、删除、等的工具包


## 使用方式
### 一、创建
```java
    File file = new File("d://1text.txt");
    //创建文件
    FileUtil.createFile(file);
    //创建文件夹
    FileUtil.createDirectory(new File("d:\\12"));
    //创建文件夹下级联创建
    FileUtil.createDirectory(new File("d:\\123\\12"), true);
```
<br>

### 二、写入

```java
    //将123写入文件、覆盖之前文件里的数据
    FileUtil.write(file, "123");
    FileUtil.writeStringToFile(file, "123");
    FileUtil.writeByteArrayToFile(file, "123".getBytes());
    //追加字符串
    FileUtil.write(file, "你好", true);
    FileUtil.writeStringToFile(file, "你好", true);
    FileUtil.writeByteArrayToFile(file, "你好".getBytes(), true);
```
<br>

### 三、查看

```java
    FileUtil.readFileToString(file);
    FileUtil.readFileToByteArray(file);
```
<br>

### 四、拷贝

```java
    FileUtil.createFile(new File("d:\\abcabc\\test.jpg"));
    FileUtil.createFile(new File("d:\\abcabc\\test-copy.jpg"));
    //将URL拷贝到本地硬盘中
    FileUtil.copyURLToFile(new URL("https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=3300305952,1328708913&fm=27&gp=0.jpg"),
                new File("d:\\abcabc\\test.jpg"));
    //copy硬盘文件、支持copyDirectory
    InputStream in = FileUtil.openInputStream(new File("d:\\abcabc\\test.jpg"));
    FileUtil.copyToFile(in,new File("d:\\abcabc\\test-copy.jpg"));
    IOUtil.close(in);
```
<br>

### 五、移动

```java
    //移动文件
    FileUtil.moveFile( new File("d:\\abcabc\\test-copy.jpg"),new File("d:\\abcabc\\123.jpg"));
    //移动目录
    FileUtil.moveDirectory(new File("d:\\abcabc"),new File("d:\\abcabc1"));

```
<br>

### 六、删除

```java
    //删除文件或文件夹
    FileUtil.delete(file);
    //删除文件或文件夹、删除失败会抛出异常
    FileUtil.forceDelete(new File("d:\\123\\12"));
    //删除文件夹、删除失败会抛出异常
    FileUtil.deleteDirectory(new File("d:\\12"));
    //清空文件夹下的所有文件
    FileUtil.cleanDirectory(new File("d:\\abcabc1"));

```
<br>


