package cn.dolphin.core.exception;

import cn.dolphin.core.msg.RequestMsg;

/**
 * 访问Token异常
 *
 */
public final class TokenRuntimException extends BaseRuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * 常用异常：Token为空
     */
    public static final TokenRuntimException NULL = new TokenRuntimException(RequestMsg.TokenNull);

    /**
     * 常用异常：Token非法
     */
    public static final TokenRuntimException ILLEGAL = new TokenRuntimException(RequestMsg.TokenIllegal);

    /**
     * 常用异常：Token无效（过期或未认证）
     */
    public static final TokenRuntimException ERROR = new TokenRuntimException(RequestMsg.TokenError);

    public TokenRuntimException(){
        super();
    }
    public TokenRuntimException(String message){
        super(message);
    }
    public TokenRuntimException(String message, Throwable cause) {
        super(message, cause);
    }
}
