package cn.dolphin.core.exception;

/**
 * 业务警告 -主动抛出- 正常错误
 *
 * 1 场景：用户正常操作时出现业务错误，需要提示错误信息到客户端
 * 2 直接通知错误信息到客户端，不需要处理
 * 3 将导致事务回滚的业务异常
 *
 */
public class ServiceRuntimeException extends BaseRuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * 服务异常
     */
    public static final ServiceRuntimeException COMMON = new ServiceRuntimeException("服务异常，请稍后再试");

    public ServiceRuntimeException() {
        super();

    }

    public ServiceRuntimeException(String message, Throwable cause, boolean enableSuppression,
                                   boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public ServiceRuntimeException(String message, Throwable cause) {
        super(message, cause);

    }

    public ServiceRuntimeException(String message) {
        super(message);

    }

    public ServiceRuntimeException(Throwable cause) {
        super(cause);

    }

}