package cn.dolphin.core.exception;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 业务警告 -主动抛出- 正常错误
 *
 * 1 场景：用户正常操作时出现业务错误，需要提示错误信息到客户端
 * 2 直接通知错误信息到客户端，不需要处理
 * 3 不会导致事务回滚的业务异常
 *
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class ServiceException extends BaseCheckedException{

    private static final long serialVersionUID = 1L;

    private String code;
    private String message;
    private Object data;

    public ServiceException() {
        super();

    }

    public ServiceException(String message, Throwable cause, boolean enableSuppression,
                            boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);

    }

    public ServiceException(String message) {
        super(message);

    }

    public ServiceException(Throwable cause) {
        super(cause);

    }

    public ServiceException(Exception e) {
        super(e);
    }

    public ServiceException(String code, String message) {
        super(message);
        this.code = code;
    }

    public ServiceException(String code, String message, Object data) {
        super(message);
        this.code = code;
        this.data = data;
    }

    @Override
    public String getMessage() {
        return message;
    }

    /**
     * 获取RuntimeException异常，在做dubbo服务时可以用到，因为dubbo处理自定义异常有问题。
     */
    public RuntimeException getRuntimeException() {
        return new RuntimeException(this.getMessage());
    }

}
