package cn.dolphin.core.exception;

/**
 * 业务错误 -主动抛出- 非正常错误
 *
 * 1 场景：用户正常操作时出现业务错误，需要提示错误信息到客户端
 * 2 直接通知错误信息到客户端，不需要处理
 * 3 将导致事务回滚的业务异常
 *
 */
public class ServiceErrorRuntimeException extends BaseRuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * 服务异常
     */
    public static final ServiceErrorRuntimeException COMMON = new ServiceErrorRuntimeException("服务异常，请稍后再试");

    public ServiceErrorRuntimeException() {
        super();

    }

    public ServiceErrorRuntimeException(String message, Throwable cause, boolean enableSuppression,
                                        boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public ServiceErrorRuntimeException(String message, Throwable cause) {
        super(message, cause);

    }

    public ServiceErrorRuntimeException(String message) {
        super(message);

    }

    public ServiceErrorRuntimeException(Throwable cause) {
        super(cause);

    }

}
