package cn.dolphin.core.exception;

/**
 * 业务错误 -主动抛出- 非正常错误
 *
 * 1 场景：用户正常操作时出现业务错误，需要提示错误信息到客户端
 * 2 直接通知错误信息到客户端，不需要处理
 * 3 不会导致事务回滚的业务异常
 *
 */
public class ServiceErrorException extends BaseCheckedException{

    private static final long serialVersionUID = 1L;

    public ServiceErrorException() {
        super();

    }

    public ServiceErrorException(String message, Throwable cause, boolean enableSuppression,
                                 boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public ServiceErrorException(String message, Throwable cause) {
        super(message, cause);

    }

    public ServiceErrorException(String message) {
        super(message);

    }

    public ServiceErrorException(Throwable cause) {
        super(cause);

    }

}
