package cn.dolphin.core.exception;

/**
 * 请求远程服务异常
 *
 * 场景：调用远程服务时，发生请求延迟、网络中断、错误响应等情况 使用：程序中请求失败时直接抛出异常，由统一异常处理器拦截
 *
 */
public class RestRuntimeException extends BaseRuntimeException {

    private static final long serialVersionUID = 1L;

    // 异常消息
    private static final String REST_ERROR_MSG = "请求远程服务失败[Feign]";
    private static final String RPC_ERROR_MSG = "调用远程服务失败[Dubbo]";
    private static final String HTTP_CLIENT_ERROR_MSG = "请求远程服务失败[Http]";
    private static final String SOCKET_ERROR_MSG = "调用远程服务失败[Socket]";
    private static final String MSG_SPLITER = " - ";

    /**
     * 常用异常：Spring Cloud 请求远程服务失败
     */
    public static final RestRuntimeException REST_ERROR = new RestRuntimeException(REST_ERROR_MSG);

    /**
     * 常用异常：Dubbo 请求远程服务失败
     */
    public static final RestRuntimeException RPC_ERROR = new RestRuntimeException(RPC_ERROR_MSG);

    /**
     * 常用异常：Http Client 请求远程服务失败
     */
    public static final RestRuntimeException HTTP_CLIENT_ERROR = new RestRuntimeException(HTTP_CLIENT_ERROR_MSG);

    /**
     * 常用异常：Socket 请求远程服务失败
     */
    public static final RestRuntimeException SOCKET_ERROR = new RestRuntimeException(SOCKET_ERROR_MSG);

    /**
     * 整合异常消息
     *
     * @param type
     *            请求类型：1 Spring Cloud,2 Dubbo，3 Http Client，4 Socket，其它 直接输出消息
     * @param msg
     *            信息，null则只输出类型信息
     * @return
     *
     */
    public static final String getMsg(int type, String msg) {
        //请求类型
        String typeMsg = null;
        switch (type) {
            case 1:
                typeMsg = REST_ERROR_MSG;
                break;
            case 2:
                typeMsg = RPC_ERROR_MSG;
                break;
            case 3:
                typeMsg = HTTP_CLIENT_ERROR_MSG;
                break;
            case 4:
                typeMsg = SOCKET_ERROR_MSG;
                break;
            default:
                return msg;
        }
        //异常消息
        if (msg == null) {
            return typeMsg;
        }else{
            return typeMsg + MSG_SPLITER + msg;
        }
    }

    public RestRuntimeException() {
        super();
    }

    public RestRuntimeException(String message, Throwable cause, boolean enableSuppression,
                                boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public RestRuntimeException(String message, Throwable cause) {
        super(message, cause);

    }

    /**
     * 构造
     *
     * @param type
     *            请求类型：1 Spring Cloud,2 Dubbo，3 Http Client，4 Socket
     */
    public RestRuntimeException(int type, Throwable cause) {
        super(getMsg(type, null), cause);

    }

    /**
     * 构造
     *
     * @param type
     *            请求类型：1 Spring Cloud,2 Dubbo，3 Http Client，4 Socket，其它 直接输出消息
     * @param message
     *            信息，null则只输出类型信息
     */
    public RestRuntimeException(int type, String message) {
        super(getMsg(type, message));

    }

    /**
     * 构造
     *
     * @param type
     *            请求类型：1 Spring Cloud,2 Dubbo，3 Http Client，4 Socket，其它 直接输出消息
     * @param message
     *            信息，null则只输出类型信息
     */
    public RestRuntimeException(int type, String message, Throwable cause) {
        super(getMsg(type, message), cause);

    }

    public RestRuntimeException(String message) {
        super(message);

    }

    public RestRuntimeException(Throwable cause) {
        super(cause);

    }

}
