package cn.dolphin.core.exception;

import cn.dolphin.core.msg.OperationMsg;

/**
 * 请求异常
 *
 * 捕捉WEB程序中的非法请求
 * 程序中对该异常处理通常比较粗暴：不做处理，简单回应或不作回应。
 *
 */
public final class RequestRuntimException extends BaseRuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * 常用异常：通用非法请求
     */
    public static final RequestRuntimException ILLEGAL = new RequestRuntimException(OperationMsg.REQUEST_ILLEGAL);

    /**
     * 常用异常：通用操作错误
     */
    public static final RequestRuntimException ERROR = new RequestRuntimException(OperationMsg.OPERATION_ERROR);

    /**
     * 常用异常：通用操作重复
     */
    public static final RequestRuntimException REPEAT = new RequestRuntimException(OperationMsg.OPERATION_REPEAT);

    /**
     * 常用异常：通用操作失败
     */
    public static final RequestRuntimException FAIL = new RequestRuntimException(OperationMsg.OPERATION_FAIL);

    public RequestRuntimException(){
        super();
    }
    public RequestRuntimException(String message){
        super(message);
    }
    public RequestRuntimException(String message, Throwable cause) {
        super(message, cause);
    }
}
