package cn.dolphin.core.exception;


import cn.dolphin.core.msg.ParamMsg;

/**
 * 参数异常
 *
 * 场景：开发者未按规定校验和传递参数
 * 使用：程序中参数不合法时直接抛出异常，由统一异常处理器拦截，传递到程序的请求端在开发时处理
 *
 */
public class ParamRuntimeException extends BaseRuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * 常用异常：参数为空
     */
    public static final ParamRuntimeException NULL = new ParamRuntimeException(ParamMsg.NULL);

    /**
     * 常用异常：参数不符合规范
     */
    public static final ParamRuntimeException ILLEGAL = new ParamRuntimeException(ParamMsg.ILLEGAL);

    /**
     * 常用异常：参数错误，不是要求的参数，不符合规范
     */
    public static final ParamRuntimeException ERROR = new ParamRuntimeException(ParamMsg.ERROR);

    /**
     * 数据不存在：根据参数查询的数据不存在
     */
    public static final ParamRuntimeException DATA_NOT_FOUND = new ParamRuntimeException(ParamMsg.DATA_NOT_FOUND);
    /**
     * 数据为空：根据参数查询的数据为空
     */
    public static final ParamRuntimeException DATA_NULL = new ParamRuntimeException(ParamMsg.DATA_NULL);

    public ParamRuntimeException() {
        super();
    }

    public ParamRuntimeException(String message, Throwable cause, boolean enableSuppression,
                                 boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public ParamRuntimeException(String message, Throwable cause) {
        super(message, cause);

    }

    public ParamRuntimeException(String message) {
        super(message);

    }

    public ParamRuntimeException(Throwable cause) {
        super(cause);

    }

}
