package cn.dolphin.core.exception;

/**
 * IO错误的运行时异常
 */
public class IoRuntimeException extends BaseRuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * 文件管理：获取、移动、复制、删除、创建、获取、遍历
     */
    public static final String FileManager = "文件管理";
    /**
     * 文件属性：长度、磁盘可用空间、名称、比较、修改时间
     */
    public static final String FileAttr = "文件属性";
    /**
     * 文件读写：读取、输出
     */
    public static final String FileIo = "文件读写";
    /**
     * 文件IO流：获取输入流、获取输出流、复制到输出流、从输入流读取
     */
    public static final String FileStream = "文件IO流";

    /**
     * IO流管理：获取、缓冲
     */
    public static final String IoManager = "IO流管理";
    /**
     * IO流属性：长度、名称、比较、修改时间
     */
    public static final String IoAttr = "IO流属性";
    /**
     * IO流读写：读取、输出、跳过
     */
    public static final String IoIo = "IO流读写";

    /**
     * 关闭IO资源：InputStream/OutputStream/Writer/Reader/Socket/Selector/
     * ServerSocket等
     */
    public static final String CloseIo = "关闭IO资源";

    /**
     * 压缩：Zip、Gzip等文件的压缩和解压缩
     */
    public static final String Compress = "文件压缩";
    /**
     * 文件Nio：通道读写
     */
    public static final String NioFile = "文件NIO";
    /**
     * POI读写
     */
    public static final String PoiIo = "POI读写";
    /**
     * 文件上传下载
     */
    public static final String UDIo = "上传下载";
    /**
     * 二维码生成
     */
    public static final String QRIo = "二维码";
    /**
     * 图片处理
     */
    public static final String IMGIo = "图片处理";


    public IoRuntimeException() {
        super();
    }

    public IoRuntimeException(String message) {
        super(message);
    }

    public IoRuntimeException(String message, Throwable cause) {
        super(message, cause);

    }
}
