package cn.dolphin.core.exception;

/**
 * HTTP操作的异常
 */
public class HttpClientException extends BaseRuntimeException{

    private static final long serialVersionUID = -6331376879800219105L;

    private String code;
    private String message;
    private Object data;

    public HttpClientException(String message, Throwable cause, boolean enableSuppression,
                            boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public HttpClientException(String message, Throwable cause) {
        super(message, cause);
    }

    public HttpClientException(String message) {
        super(message);
    }

    public HttpClientException(Throwable cause) {
        super(cause);
    }

    public HttpClientException(Exception e) {
        super(e);
    }

    public HttpClientException(String code, String message) {
        super(message);
        this.code = code;
    }

    public HttpClientException(String code, String message, Object data) {
        super(message);
        this.code = code;
        this.data = data;
    }
    public HttpClientException() {
        super();

    }

    @Override
    public String getMessage() {
        return message;
    }

    /**
     * 获取RuntimeException异常，在做dubbo服务时可以用到，因为dubbo处理自定义异常有问题。
     */
    public RuntimeException getRuntimeException() {
        return new RuntimeException(this.getMessage());
    }
}
