package cn.dolphin.core.exception;

/**
 * 远程连接异常
 *
 */
public final class ConnRuntimeException extends BaseRuntimeException{

    private static final long serialVersionUID = 1L;

    private static final String CONN_ERROR = "远程连接失败";
    /**
     * 常用异常：连接失败
     */
    public static final ConnRuntimeException NULL = new ConnRuntimeException(CONN_ERROR);

    public ConnRuntimeException(){
        super();
    }
    public ConnRuntimeException(String message){
        super(message);
    }
    public ConnRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }
    public ConnRuntimeException(Throwable cause) {
        super(CONN_ERROR, cause);
    }
}
