package cn.dolphin.core.exception;

/**
 * 权限异常
 *
 * 场景：用户没有操作权限，用户非法请求，前端未屏蔽没有权限的按钮
 * 使用：程序中没权限时直接抛出异常，由统一异常处理器拦截，告知前端权限异常
 *
 */
public class AuthRuntimeException extends BaseRuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * 常用异常：没有权限
     */
    public static final AuthRuntimeException NULL = new AuthRuntimeException("没有权限");


    public AuthRuntimeException() {
        super();
    }

    public AuthRuntimeException(String message, Throwable cause, boolean enableSuppression,
                                boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);

    }

    public AuthRuntimeException(String message, Throwable cause) {
        super(message, cause);

    }

    public AuthRuntimeException(String message) {
        super(message);

    }

    public AuthRuntimeException(Throwable cause) {
        super(cause);

    }

}
