package cn.dolphin.core.exception;

import cn.dolphin.core.result.ResultCode;
import cn.dolphin.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 接口异常
 */
//@Data
//@EqualsAndHashCode(callSuper=false)
public class ApiException extends BaseRuntimeException {
    private static final long serialVersionUID = 16789476595630713L;

    @JsonIgnore
    private String code;
    @JsonIgnore
    private Object data;

    public ApiException(String msg) {
        super(msg);
    }

    public ApiException(Exception e) {
        super(StrUtil.isBlank(e.getMessage())?"接口异常":e.getMessage(),e);
        if(e instanceof ApiException){
            this.code = ((ApiException) e).getCode();
        }else{
            this.code = ResultCode.ERROR_CODE;
        }
    }

    public ApiException(String msg, Throwable e) {
        super(StrUtil.isBlank(msg)?"接口异常":msg, e);
        if(e instanceof ApiException){
            this.code = ((ApiException) e).getCode();
        }else{
            this.code = ResultCode.ERROR_CODE;
        }

    }



    public ApiException(String code, String msg) {
        super(StrUtil.isBlank(msg)?"接口异常":msg);
        if(StrUtil.isBlank(code)){
            this.code = ResultCode.ERROR_CODE;
        }else{
            this.code = code;
        }

    }

    public ApiException(String code, String msg, Object data) {
        super(StrUtil.isBlank(msg)?"接口异常":msg);
        if(StrUtil.isBlank(code)){
            this.code = ResultCode.ERROR_CODE;
        }else{
            this.code = code;
        }
        this.data = data;
    }


    /**
     * 获取RuntimeException异常，在做dubbo服务时可以用到，因为dubbo处理自定义异常有问题。
     */
    public RuntimeException getRuntimeException() {
        return new RuntimeException(this.getMessage());
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Object getData() {
        //object 为空返回空{}
        if(data == null){
            Object obj= new Object();
            return obj ;
        }
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

}
