package cn.dolphin.core.enums;

/**
 * 权限验证码
 */
public enum SecurityEnum {
    // 系统公共状态码
    API_000000("000000","成功"),
    API_000001("000001","服务器内部错误,操作失败"),
    API_000002("000002","参数为空"),
    API_000003("000003","参数错误"),
    API_000004("000004","参数不符合规范"),
    API_000005("000005","数据为空"),
    API_000006("000006","数据不存在"),
    API_000007("000007","时间格式错误"),
    API_000008("000008","数据已经存在"),
    //9000 授权状态码
    API_009000("009000","账户已经存在，请勿重新添加！"),
    API_009001("009001","应用标识key，已经被管理员禁用！"),
    API_009002("009002","刷新TOKEN，不合法的用户，请开发者认真比对！"),
    API_009003("009003","刷新TOKEN，不合法的 access_token，请开发者认真比对！"),
    API_009004("009004","缺少 appkey 参数"),
    API_009005("009005","不合法的 appkey ，请开发者检查 appkey 的正确性，避免异常字符，注意大小写"),
    API_009006("009006","不合法的 sign "),
    API_009007("009007","缺少 sign 参数"),
    API_009008("009008","缺少 timestamp 参数"),
    API_009009("009009","access_token 超时，请检查 access_token 的有效期"),
    API_009010("009010","access_token 无效"),
    API_009011("009011","缺少 token 参数"),
    API_009012("009012","不合法的 appsecret ，请开发者检查 appsecret 的正确性，避免异常字符，注意大小写"),
    API_009013("009013","缺少 appsecret 参数"),
    API_009014("009014","缺少 timestamp 参数"),
    API_009015("009015","缺少 noncestr 参数"),
    API_009016("009016","授权请求规则不合法，请开发者检查授权注解规则是否在允许范围内"),
    API_009017("009017","授权证书生成失败，请开发者检查授权规则是否在允许范围内"),
    API_009018("009018","您的证书无效，请核查服务器是否取得授权或重新申请证书"),
    API_009019("009019","用户未登录，请核查用户凭证是否合法");

    private String code;
    private String msg;


    /**
     * Msg string.
     *
     * @return the string
     */
    public String msg() {
        return msg;
    }

    /**
     * Code int.
     *
     * @return the int
     */
    public String code() {
        return code;
    }

    SecurityEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * Gets enum.
     *
     * @param code the code
     *
     * @return the enum
     */
    public static SecurityEnum getEnum(String code) {
        for (SecurityEnum ele : SecurityEnum.values()) {
            if (ele.code().equals(code)) {
                return ele;
            }
        }
        return API_000001;
    }
}

