package cn.dolphin.core.enums;

/**
 * 时间枚举
 */
public enum DateEnum {

    /**replace with {@link DateEnum#FORMAT_YYMM_MID}*/
    @Deprecated
    FORMAT_YYMM("yyyy-MM"),
    /**replace with {@link DateEnum#FORMAT_YYWW_MID}*/
    @Deprecated
    FORMAT_YYWW("yyyy-ww"),
    /**replace with {@link DateEnum#FORMAT_YYMMDD_MID}*/
    @Deprecated
    FORMAT_YYMMDD("yyyy-MM-dd"),
    /**replace with {@link DateEnum#FORMAT_YYMMDDHM_MID}*/
    @Deprecated
    FORMAT_YYMMDDHM("yyyy-MM-dd HH:mm"),
    /**replace with {@link DateEnum#FORMAT_YYMMDDHMS_MID}*/
    @Deprecated
    FORMAT_YYMMDDHMS("yyyy-MM-dd HH:mm:ss"),
    /**replace with {@link DateEnum#FORMAT_YYMMDDHMSS_MID}*/
    @Deprecated
    FORMAT_YYMMDDHMSS("yyyy-MM-dd HH:mm:ss SSS"),
    /**replace with {@link DateEnum#FORMAT_YYMMDDHM_SLASH}*/
    @Deprecated
    FORMAT_YYMMDDHM_GAP_SLASH("yyyy/MM/dd HH:mm"),
    /**replace with {@link DateEnum#FORMAT_YYMMDD_NON}*/
    @Deprecated
    FORMAT_YYMMDD2("yyyyMMdd"),
    /**replace with {@link DateEnum#FORMAT_YYMMDDHMS_NON}*/
    @Deprecated
    FORMAT_YYMMDDHMS_NO_GAP("yyyyMMddHHmmss"),

    /**中杠分隔符**/
    FORMAT_YYMM_MID("yyyy-MM"),
    FORMAT_YYWW_MID("yyyy-ww"),
    FORMAT_YYMMDD_MID("yyyy-MM-dd"),
    FORMAT_YYMMDD_MID_01("yyyy-MM-01"),
    FORMAT_YYMMDDH_MID("yyyy-MM-dd HH"),
    FORMAT_YYMMDDHM_MID("yyyy-MM-dd HH:mm"),
    FORMAT_YYMMDDHMS_MID("yyyy-MM-dd HH:mm:ss"),
    FORMAT_YYMMDDHMSS_MID("yyyy-MM-dd HH:mm:ss SSS"),
    /**无隔符**/
    FORMAT_YYMM_NON("yyyyMM"),
    FORMAT_YYWW_NON("yyyyww"),
    FORMAT_YYMMDD_NON("yyyyMMdd"),
    FORMAT_YYMMDDH_NON("yyyyMMddHH"),
    FORMAT_YYMMDDHM_NON("yyyyMMddHHmm"),
    FORMAT_YYMMDDHMS_NON("yyyyMMddHHmmss"),
    FORMAT_YYMMDDHMSS_NON("yyyyMMddHHmmssSSS"),

    /**斜杠分隔符**/
    FORMAT_YYMM_SLASH("yy/yy/MM"),
    FORMAT_YYWW_SLASH("yyyy/ww"),
    FORMAT_YYMMDD_SLASH("yyyy/MM/dd"),
    FORMAT_YYMMDDH_SLASH("yyyy/MM/dd HH"),
    FORMAT_YYMMDDHM_SLASH("yyyy/MM/dd HH:mm"),
    FORMAT_YYMMDDHMS_SLASH("yyyy/MM/dd HH:mm:ss"),
    FORMAT_YYMMDDHMSS_SLASH("yyyy/MM/dd HH:mm:ss:SSS"),

    /**时间**/
    FORMAT_HM("HH:mm"),
    FORMAT_HMS("HH:mm:ss"),
    FORMAT_HMSS("HH:mm:ss SSS"),

    ;

    private String fmt;

    DateEnum(String fmt) {
        this.fmt = fmt;
    }

    public String getFmt() {
        return fmt;
    }
}
